/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.betterx.bclib.BCLibPatch;
import org.betterx.bclib.api.v2.dataexchange.DataExchangeAPI;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.Chunker;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.HelloClient;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.HelloServer;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.RequestFiles;
import org.betterx.bclib.api.v2.dataexchange.handler.autosync.SendFiles;
import org.betterx.bclib.api.v2.generator.BCLibEndBiomeSource;
import org.betterx.bclib.api.v2.generator.BCLibNetherBiomeSource;
import org.betterx.bclib.api.v2.generator.GeneratorOptions;
import org.betterx.bclib.api.v2.levelgen.LevelGenEvents;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.structures.TemplatePiece;
import org.betterx.bclib.api.v2.levelgen.surface.rules.Conditions;
import org.betterx.bclib.api.v2.poi.PoiManager;
import org.betterx.bclib.api.v3.levelgen.features.blockpredicates.BlockPredicates;
import org.betterx.bclib.api.v3.levelgen.features.placement.PlacementModifiers;
import org.betterx.bclib.api.v3.tag.BCLBlockTags;
import org.betterx.bclib.commands.CommandRegistry;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.networking.VersionChecker;
import org.betterx.bclib.recipes.AnvilRecipe;
import org.betterx.bclib.recipes.CraftingRecipes;
import org.betterx.bclib.registry.BaseBlockEntities;
import org.betterx.bclib.registry.BaseRegistry;
import org.betterx.worlds.together.WorldsTogether;
import org.betterx.worlds.together.util.Logger;
import org.betterx.worlds.together.world.WorldConfig;

public class BCLib
implements ModInitializer {
    public static final String MOD_ID = "bclib";
    public static final Logger LOGGER = new Logger("bclib");
    public static final boolean RUNS_NULLSCAPE = FabricLoader.getInstance().getModContainer("nullscape").isPresent();

    public void onInitialize() {
        WorldsTogether.onInitialize();
        LevelGenEvents.register();
        BlockPredicates.ensureStaticInitialization();
        BCLBiomeRegistry.ensureStaticallyLoaded();
        BaseRegistry.register();
        GeneratorOptions.init();
        BaseBlockEntities.register();
        BCLibEndBiomeSource.register();
        BCLibNetherBiomeSource.register();
        CraftingRecipes.init();
        WorldConfig.registerModCache(MOD_ID);
        DataExchangeAPI.registerMod(MOD_ID);
        AnvilRecipe.register();
        Conditions.registerAll();
        CommandRegistry.register();
        BCLBlockTags.ensureStaticallyLoaded();
        PoiManager.registerAll();
        DataExchangeAPI.registerDescriptors(List.of(HelloClient.DESCRIPTOR, HelloServer.DESCRIPTOR, RequestFiles.DESCRIPTOR, SendFiles.DESCRIPTOR, Chunker.DESCRIPTOR));
        BCLibPatch.register();
        TemplatePiece.ensureStaticInitialization();
        PlacementModifiers.ensureStaticInitialization();
        Configs.save();
        WorldsTogether.FORCE_SERVER_TO_BETTERX_PRESET = Configs.SERVER_CONFIG.forceBetterXPreset();
        VersionChecker.registerMod(MOD_ID);
    }

    public static boolean isDevEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static class_2960 makeID(String path) {
        return new class_2960(MOD_ID, path);
    }
}

